<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_title_shape',
    [
        'label' => __('Section Title Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$layout_one_project = new \Elementor\Repeater();

$layout_one_project->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'agrion-addon'),
        'label_block' => true,
    ]
);

agrion_elementor_heading_option($layout_one_project, 'Project Title', 'h3', 'layout_one');


$layout_one_project->add_control(
    'url',
    [
        'label' => __('Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$layout_one_project->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_one_project->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_one_project_items',
    [
        'label' => __('Project Items', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_project->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'bg_image',
    [
        'label' => __('Section Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
