<?php

$this->start_controls_section(
    'layout_five_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);


$layout_five_project = new \Elementor\Repeater();

$layout_five_project->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'agrion-addon'),
        'label_block' => true,
    ]
);

agrion_elementor_heading_option($layout_five_project, 'Project Title', 'h3', 'layout_five');


$layout_five_project->add_control(
    'url',
    [
        'label' => __('Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$layout_five_project->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_five_project->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_five_project_items',
    [
        'label' => __('Project Items', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_project->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
