<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Slider Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_sliders = new \Elementor\Repeater();


$layout_three_sliders->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($layout_three_sliders, 'Title', 'h2', 'layout_three');

$layout_three_sliders->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

$layout_three_sliders->add_control(
    'sub_title_left_shape',
    [
        'label' => __('Sub Title Left Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_sliders->add_control(
    'sub_title_right_shape',
    [
        'label' => __('Sub Title Right Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

agrion_elementor_heading_option($layout_three_sliders, 'Sub Title', 'p', 'layout_three');

$layout_three_sliders->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_three_sliders->add_control(
    'button_icon',
    [
        'label' => __('Button Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_three_sliders->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$layout_three_sliders->add_control(
    'background_image',
    [
        'label' => __('Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);



$this->add_control(
    'layout_three_sliders',
    [
        'label' => __('Main Slider', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_sliders->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);



$this->end_controls_section();
