<?php
$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_icon_box = new \Elementor\Repeater();


$layout_two_icon_box->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'agrion-addon'),
        'label_block' => true,
    ]
);

agrion_elementor_heading_option($layout_two_icon_box, 'Title', 'h2', 'layout_two');

$layout_two_icon_box->add_control(
    'url',
    [
        'label' => __('Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);


$layout_two_icon_box->add_control(
    'text',
    [
        'label' => __('Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true,
    ]
);

$layout_two_icon_box->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-agriculture',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_two_icon_box',
    [
        'label' => __('Icon Box', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_icon_box->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_bg_image',
    [
        'label' => __('Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
