<?php
$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_icon_box = new \Elementor\Repeater();


$layout_three_icon_box->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'agrion-addon'),
        'label_block' => true,
    ]
);

agrion_elementor_heading_option($layout_three_icon_box, 'Title', 'h2', 'layout_three');

$layout_three_icon_box->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Sub Title', 'agrion-addon'),
        'label_block' => true,
    ]
);


$layout_three_icon_box->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-global-shipping',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_icon_box',
    [
        'label' => __('Icon Box', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_icon_box->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
