<?php
$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$icon_box = new \Elementor\Repeater();

$icon_box->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-global-shipping',
            'library' => 'custom-icon',
        ],
    ]
);

$icon_box->add_control(
    'text',
    [
        'label' => __('Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true,
    ]
);

agrion_elementor_heading_option($icon_box, 'Text', 'h2', 'layout_one');

$this->add_control(
    'icon_box',
    [
        'label' => __('Icon Box', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $icon_box->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'title' => __('Default Title', 'agrion-addon'),
                'text' => __('Default Text', 'agrion-addon'),
                'icon' => [
                    'value' => 'icon-farm',
                    'library' => 'custom-icon',
                ],
            ],
        ],
        'title_field' => '{{{ text }}}',
    ]
);

$this->end_controls_section();
