<?php


$this->start_controls_section(
    'logo_section',
    [
        'label' => __('Site Logo', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'light_logo',
    [
        'label' => __('Light Logo', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'logo_dimension',
    [
        'label' => __('Logo Dimension', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
        'description' => __('Set Custom Logo Size.', 'agrion-addon'),
        'default' => [
            'width' => '134',
            'height' => '34',
        ],
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'nav_section',
    [
        'label' => __('Navigation', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'nav_menu',
    [
        'label' => __('Select Nav Menu', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => agrion_get_nav_menu(),
        'label_block' => true,
    ]
);

$this->end_controls_section();

//top bar
$this->start_controls_section(
    'topbar_section',
    [
        'label' => __('Topbar', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three']
        ]

    ]
);


$topbar_infos = new \Elementor\Repeater();

$topbar_infos->add_control(
    'topbar_icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pin',
            'library' => 'custom',
        ],
        'label_block' => true,
    ]
);

$topbar_infos->add_control(
    'topbar_info_text',
    [
        'label' => __('Topbar Right Info Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('88 Road Broklyn Golden Street. New York', 'agrion-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'topbar_infos',
    [
        'label' => __('Topbar Info', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $topbar_infos->get_controls(),
        'title_field' => '{{{ topbar_info_text }}}',
    ]
);

$this->end_controls_section();

//other
$this->start_controls_section(
    'others_section',
    [
        'label' => __('Others', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'search_enable',
    [
        'label' => __('Enable Search?', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'agrion-addon'),
        'label_off' => __('No', 'agrion-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'cart_enable',
    [
        'label' => __('Display Cart Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'agrion-addon'),
        'label_off' => __('No', 'agrion-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$nav_social_icons = new \Elementor\Repeater();

$nav_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$nav_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'nav_social_icons',
    [
        'label' => __('Social Icons', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $nav_social_icons->get_controls(),
        'prevent_empty' => false,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ],
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->add_control(
    'call_icon',
    [
        'label' => __('Call Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-phone',
            'library' => 'custom-icon',
        ],
        'label_block' => true,
        'condition'   => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'call_number',
    [
        'label' => __('Call Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('+92 (0088) 6823', 'agrion-addon'),
        'label_block' => true,
        'condition'   => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'call_url',
    [
        'label' => __('Call Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('#', 'agrion-addon'),
        'label_block' => true,
        'condition'   => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Get Free Quote', 'agrion-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'button_icon',
    [
        'label' => __('Button Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
    ]
);


$this->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'mobile_menu_section',
    [
        'label' => __('Mobile Drawer', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'mobile_menu_logo',
    [
        'label' => __('Mobile Drawer Logo', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'mobile_email',
    [
        'label' => __('Email', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Email', 'agrion-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'mobile_phone',
    [
        'label' => __('Phone', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Phone Number', 'agrion-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'mobile_url',
    [
        'label' => __('Phone Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Phone Url', 'agrion-addon'),
        'label_block' => true,
    ]
);

$mobile_menu_social_icons = new \Elementor\Repeater();

$mobile_menu_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Social Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa-facebook-f',
            'library' => 'custom',
        ],
        'label_block' => true,
    ]
);

$mobile_menu_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'mobile_menu_social_icons',
    [
        'label' => __('Social Icons', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $mobile_menu_social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_icon' => 'fa-facebook-f',
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->end_controls_section();
