<?php


$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$funfact = new \Elementor\Repeater();

$funfact->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('AGRICULTURE PRODUCTS', 'agrion-addon'),
        'label_block' => true
    ]
);

$funfact->add_control(
    'count_number',
    [
        'label' => __('Count Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('6420', 'agrion-addon'),
        'label_block' => true
    ]
);


$funfact->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-seeds',
            'library' => 'custom-icon',
        ],
    ]
);

$funfact->add_control(
    'shape_one',
    [
        'label' => __('Shape One', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$funfact->add_control(
    'shape_two',
    [
        'label' => __('Shape Two', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'funfact',
    [
        'label' => __('Fun Fact Items', 'agrion-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $funfact->get_controls(),
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'bg_image',
    [
        'label' => __('Section Background Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
