<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$this->add_control(
    'title',
    [
        'label' => __('Widget Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Contact', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_one_item = new \Elementor\Repeater();

$layout_one_item->add_control(
    'content',
    [
        'label' => __('Content', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => wp_kses(__('<a href="tel:9200886823">+92 (0088) 6823</a>'), 'agrion_allowed_tags')
    ]
);

$layout_one_item->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-phone-square-alt',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_items',
    [
        'label' => __('Contact Info', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_item->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->add_control(
    'mailchimp_url',
    [
        'label' => __('Add Mailchimp URL', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
        'label_block' => true
    ]
);

$this->add_control(
    'mc_input_placeholder',
    [
        'label' => __('Input Placeholder Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Email address', 'agrion-addon'),
        'label_block' => true
    ]
);

$this->end_controls_section();
