<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'options' => [
            'layout_one' => __('Layout One', 'agrion-addon'),
        ]
    ]
);


$fancy_box = new \Elementor\Repeater();

$fancy_box->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Home page 01', 'agrion-addon'),
        'label_block' => true,
    ]
);

$fancy_box->add_control(
    'btn_one',
    [
        'label' => __('Button One', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Multi Page', 'agrion-addon'),
        'label_block' => true,
    ]
);

$fancy_box->add_control(
    'btn_one_url',
    [
        'label' => __('Button One Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$fancy_box->add_control(
    'btn_two',
    [
        'label' => __('Button Two', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('One Page', 'agrion-addon'),
        'label_block' => true,
    ]
);

$fancy_box->add_control(
    'btn_two_url',
    [
        'label' => __('Button Two Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$fancy_box->add_control(
    'image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'fancy_box',
    [
        'label' => __('Fancy Box', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $fancy_box->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'title' => __('Home page 01', 'agrion-addon'),
            ],
        ],
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
