<?php

$this->start_controls_section(
    'contact_form_section',
    [
        'label' => __('Contact Form', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$this->add_control(
    'select_wpcf7_form',
    [
        'label'       => esc_html__('Select your contact form 7', 'agrion-addon'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => agrion_post_query('wpcf7_contact_form'),
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Contents', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_title_shape',
    [
        'label' => __('Section Title Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$this->add_control(
    'layout_one_summary',
    [
        'label' => __('Summary', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary', 'agrion-addon'),
        'default' => __('Default Summary Text', 'agrion-addon'),
    ]
);

$layout_one_contact_info = new \Elementor\Repeater();

$layout_one_contact_info->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Have Question?', 'agrion-addon'),
    ]
);

$layout_one_contact_info->add_control(
    'content',
    [
        'label' => __('Content', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Content', 'agrion-addon'),
        'default' => __('Default Content', 'agrion-addon'),
    ]
);


$layout_one_contact_info->add_control(
    'icon',
    [
        'label' => __('Check Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fas fa-phone-alt',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'layout_one_contact_info',
    [
        'label' => __('Contact Info', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_contact_info->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'bg_shape',
    [
        'label' => __('Background Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
