<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Title', 'h2', 'layout_two');


$this->add_control(
    'layout_two_text',
    [
        'label' => __('Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_phone',
    [
        'label' => __('Phone number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('+ 1- (246) 333-0088', 'agrion-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_two_phone_url',
    [
        'label' => __('Phone Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_two_phone_icon',
    [
        'label' => __('Phone Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-ringing',
            'library' => 'custom-icon',
        ],
    ]
);


$this->end_controls_section();
