<?php
$this->start_controls_section(
    'header_title',
    [
        'label' => __('Blog Header', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three']
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_title_shape',
    [
        'label' => __('Section Title Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$this->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('View All Posts ', 'agrion-addon'),
        'label_block' => true,
        'condition' => [
            'layout_type' =>  'layout_two'
        ]

    ]
);

$this->add_control(
    'button_icon',
    [
        'label' => __('Button Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
        'condition' => [
            'layout_type' =>  'layout_two'
        ]
    ]
);


$this->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
        'condition' => [
            'layout_type' =>  'layout_two'
        ]
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'post_option',
    [
        'label' => __('Post Options', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'post_count',
    [
        'label' => __('Number Of Posts', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 0,
                'max' => 15,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 6,
        ],
    ]
);


$this->add_control(
    'query_order',
    [
        'label' => __('Select Order', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => 'DESC',
        'options' => [
            'DESC' => __('DESC', 'agrion-addon'),
            'ASC' => __('ASC', 'agrion-addon'),
        ]
    ]
);

$this->add_control(
    'select_category',
    [
        'label' => __('Post Category', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => agrion_get_taxonoy('category'),
    ]
);

$this->add_control(
    'pagination_status',
    [
        'label' => __('Enable Pagination?', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'agrion-addon'),
        'label_off' => __('No', 'agrion-addon'),
        'return_value' => 'yes',
        'default' => 'no',
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four']
        ]
    ]
);


$this->end_controls_section();
