<?php

//content
$this->start_controls_section(
    'layout_three_content',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_three');

$this->add_control(
    'layout_three_sec_title_shape',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_three');


$this->add_control(
    'layout_three_summary',
    [
        'label' => __('Summary', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'agrion-addon'),
        'default' => __('Default Summary Text', 'agrion-addon'),
    ]
);

$layout_three_features_list = new \Elementor\Repeater();

$layout_three_features_list->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_three_features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_features_list',
    [
        'label' => __('Feature Lists', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_three_button_label',
    [
        'label' => __('Button Label', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Discover More', 'agrion-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_button_icon',
    [
        'label' => __('Button Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow',
            'library' => 'custom-icon',
        ],
    ]
);


$this->add_control(
    'layout_three_button_url',
    [
        'label' => __('Button Url', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'agrion-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'layout_three_section_image',
    [
        'label' => __('Images', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_image',
    [
        'label' => __('Image', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_three_img_caption',
    [
        'label' => __('Image Caption', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Image Caption', 'agrion-addon'),
        'default' => __('Default Text', 'agrion-addon'),
    ]
);

$this->add_control(
    'layout_three_count_number',
    [
        'label' => __('Count Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Count Number', 'agrion-addon'),
        'default' => __('18', 'agrion-addon'),
    ]
);

$this->add_control(
    'layout_three_count_sign',
    [
        'label' => __('Count Number', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Count Sign', 'agrion-addon'),
        'default' => __('+', 'agrion-addon'),
    ]
);

$this->add_control(
    'layout_three_bg_shape',
    [
        'label' => __('Background Shape', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
