<?php

//content
$this->start_controls_section(
    'layout_seven_content',
    [
        'label' => __('Content', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_seven'
        ]
    ]
);

$this->add_control(
    'layout_seven_sec_title',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Title', 'h2', 'layout_seven');

$this->add_control(
    'layout_seven_sec_title_shape',
    [
        'label' => __('Section Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'agrion-addon'),
        'default' => __('Default Sub Title', 'agrion-addon'),
    ]
);

agrion_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_seven');


$this->add_control(
    'layout_seven_summary',
    [
        'label' => __('Summary', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'agrion-addon'),
        'default' => __('Default Summary Text', 'agrion-addon'),
    ]
);

$layout_seven_features_list = new \Elementor\Repeater();

$layout_seven_features_list->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_seven_features_list->add_control(
    'text',
    [
        'label' => __('Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Text', 'agrion-addon'),
        'default' => __('Default Text', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_seven_features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_seven_features_list',
    [
        'label' => __('Features Lists', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_seven_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$layout_seven_progress_bar = new \Elementor\Repeater();

$layout_seven_progress_bar->add_control(
    'title',
    [
        'label' => __('Title', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'agrion-addon'),
        'default' => __('Default Title', 'agrion-addon'),
        'label_block' => true
    ]
);

$layout_seven_progress_bar->add_control(
    'count',
    [
        'label' => __('Count Text', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 0,
                'max' => 100,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 90,
        ],
    ]
);

$this->add_control(
    'layout_seven_progress_bar',
    [
        'label' => __('Progress Bar', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_seven_progress_bar->get_controls(),
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_seven_section_image',
    [
        'label' => __('Images', 'agrion-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_seven'
        ]
    ]
);

$this->add_control(
    'layout_seven_image_one',
    [
        'label' => __('Image One', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_image_two',
    [
        'label' => __('Image Two', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_seven_image_three',
    [
        'label' => __('Image Three', 'agrion-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
